/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.generators;

import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.utils.Array;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import technology.rocketjump.undermount.mapgen.model.input.GameMapGenerationParams;
import technology.rocketjump.undermount.mapgen.model.input.ShrubType;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;
import technology.rocketjump.undermount.mapgen.model.output.MapSubRegion;
import technology.rocketjump.undermount.mapgen.model.output.TileSubType;

public class ShrubPlanter {
    private static final int NUM_SHRUBS_TO_SPAWN_FROM_EACH_TREE = 3;
    public static final int MAX_SHRUB_NEIGHBOURS_ALLOWED = 2;
    private Array<GridPoint2> outerOffsets = new Array(8);
    private Array<GridPoint2> innerOffsets = new Array(9);

    public ShrubPlanter() {
        this.outerOffsets.add(new GridPoint2(-2, 0));
        this.outerOffsets.add(new GridPoint2(-2, 2));
        this.outerOffsets.add(new GridPoint2(0, 2));
        this.outerOffsets.add(new GridPoint2(2, 2));
        this.outerOffsets.add(new GridPoint2(2, 0));
        this.outerOffsets.add(new GridPoint2(2, -2));
        this.outerOffsets.add(new GridPoint2(0, -2));
        this.outerOffsets.add(new GridPoint2(-2, -2));
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                this.innerOffsets.add(new GridPoint2(x, y));
            }
        }
    }

    public void placeShrubs(GameMap map, TileSubType targetType, Random random, GameMapGenerationParams generationParams) {
        for (MapSubRegion subRegion : map.getSubRegions().values()) {
            if (!subRegion.getSubRegionType().equals((Object)targetType)) continue;
            ShrubType nonFruitShrub = this.pickShrub(generationParams, random, false);
            ShrubType fruitShrub = this.pickShrub(generationParams, random, true);
            this.placeShrubs(map, subRegion, random, nonFruitShrub, fruitShrub, generationParams.getRatioOfFruitingShrubs());
        }
    }

    private ShrubType pickShrub(GameMapGenerationParams generationParams, Random random, boolean hasFruit) {
        List<ShrubType> shrubTypes = generationParams.getShrubTypes();
        ShrubType picked = null;
        while (picked == null) {
            ShrubType aShrubType = shrubTypes.get(random.nextInt(shrubTypes.size()));
            if (aShrubType.hasFruit() != hasFruit) continue;
            picked = aShrubType;
        }
        return picked;
    }

    private void placeShrubs(GameMap map, MapSubRegion subRegion, Random random, ShrubType nonFruitShrub, ShrubType fruitShrub, float ratioOfFruitingShrubs) {
        LinkedList<GridPoint2> positionsToSpawnFrom = new LinkedList<GridPoint2>();
        LinkedList<GridPoint2> initialPositions = new LinkedList<GridPoint2>();
        int minX = subRegion.getMinX();
        int maxX = subRegion.getMaxX();
        int width = maxX - minX;
        int minY = subRegion.getMinY();
        int maxY = subRegion.getMaxY();
        int height = maxY - minY;
        for (int quarterX = 1; quarterX <= 3; ++quarterX) {
            for (int quarterY = 1; quarterY <= 3; ++quarterY) {
                initialPositions.add(new GridPoint2(minX + width / 4 * quarterX, minY + height / 4 * quarterY));
            }
        }
        for (GridPoint2 initialPosition : initialPositions) {
            if (!this.isShrubAllowedAt(initialPosition, map, subRegion)) continue;
            ShrubType typeToUse = this.pickShrubType(random, nonFruitShrub, fruitShrub, ratioOfFruitingShrubs);
            map.get(initialPosition).setShrubType(typeToUse);
            positionsToSpawnFrom.add(initialPosition);
        }
        block3: while (!positionsToSpawnFrom.isEmpty()) {
            GridPoint2 positionToSpawnFrom = (GridPoint2)positionsToSpawnFrom.removeFirst();
            for (int shrubsSpawned = 0; shrubsSpawned < 3; ++shrubsSpawned) {
                GridPoint2 validNearbyPoint = null;
                for (int i = 0; i < 6 && !this.isShrubAllowedAt(validNearbyPoint = this.randomPointNear(positionToSpawnFrom, random), map, subRegion); ++i) {
                    validNearbyPoint = null;
                }
                if (validNearbyPoint == null) continue block3;
                map.get(validNearbyPoint).setShrubType(this.pickShrubType(random, nonFruitShrub, fruitShrub, ratioOfFruitingShrubs));
                positionsToSpawnFrom.add(validNearbyPoint);
            }
        }
    }

    private ShrubType pickShrubType(Random random, ShrubType nonFruitShrub, ShrubType fruitShrub, float ratioOfFruitingShrubs) {
        boolean hasFruit = random.nextFloat() < ratioOfFruitingShrubs;
        return hasFruit ? fruitShrub : nonFruitShrub;
    }

    public GridPoint2 randomPointNear(GridPoint2 origin, Random random) {
        return origin.cpy().add(this.outerOffsets.get(random.nextInt(this.outerOffsets.size))).add(this.innerOffsets.get(random.nextInt(this.innerOffsets.size)));
    }

    public boolean isShrubAllowedAt(GridPoint2 position, GameMap map, MapSubRegion subRegionToMatch) {
        GameMapTile tileAtPosition = map.get(position);
        if (tileAtPosition == null || tileAtPosition.hasTree() || tileAtPosition.hasShrub() || tileAtPosition.hasRiver()) {
            return false;
        }
        if (tileAtPosition.getSubRegion().getSubRegionId() != subRegionToMatch.getSubRegionId()) {
            return false;
        }
        int numShrubNeighbours = 0;
        for (int x = position.x - 1; x <= position.x + 1; ++x) {
            for (int y = position.y - 1; y <= position.y + 1; ++y) {
                GameMapTile tile = map.get(x, y);
                if (tile == null || !tile.hasTree() && !tile.hasShrub()) continue;
                ++numShrubNeighbours;
            }
        }
        return numShrubNeighbours <= 2;
    }
}

